USE ezWebReports
go


CREATE TABLE DataProvider (
  DataProviderID varchar(25) NULL,
  DataProviderName varchar(100) NULL,
  DataProviderDescription varchar(255) NULL
)
go


CREATE INDEX IX1_DataProvider ON DataProvider (DataProviderID)
go


INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('SQLSERVER','System.Data.SqlClient','SQL Server')
go

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('OLEDB','System.Data.OleDb','OLE DB')
go

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('ODBC','Microsoft.Data.Odbc','ODBC.NET') 
go

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('DBPROVIDER','dbProvider','dbProvider for MySQL') 
go

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('MYSQLDIRECT','CoreLab.MySql','MySQLDirect.NET') 
go

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('ODPNET','Oracle.DataAccess','Oracle Data Provider') 
go

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('DB2NET','IBM.Data.DB2','DB2.NET Provider') 
go


CREATE TABLE DataSource (
  DataSourceID varchar(38) NULL,
  DataSourceName varchar(100) NULL,
  DataProviderID varchar(25) NULL,
  TableViewName varchar(255) NULL,
  ConnectionString varchar(255) NULL,
  LastRefreshedDate datetime NULL,
  IsOnline char(1) NULL
) 
go

CREATE INDEX IX1_DataSource ON DataSource (DataSourceID) 
go


CREATE TABLE DataSourceColumns (
  DataSourceID varchar(38) NULL,
  ColumnName varchar(50) NULL,
  Description varchar(50) NULL,
  DataType char(1) NULL,
  IsCurrency char(1) NULL,
  Decimals int NULL,
  Width int NULL,
  Heading varchar(50) NULL,
  HasLookupList char(1) NULL,
  ExampleValue1 varchar(50) NULL,
  ExampleValue2 varchar(50) NULL
) 
go

CREATE INDEX IX1_DataSourceColumns ON DataSourceColumns (DataSourceID,ColumnName) 


CREATE TABLE Filter (
  FilterID varchar(38) NULL,
  UserID varchar(50) NULL,
  DataSourceID varchar(38) NULL,
  FilterName varchar(50) NULL,
  FilterType char(1) NULL,
  LastSavedDate datetime NULL,
  WHEREClause text NULL,
  FilterDescription text NULL,
  FilterDescriptionTextOnly text NULL
) 
go

CREATE INDEX IX1_Filter ON Filter (FilterID)
go
CREATE INDEX IX2_Filter ON Filter (UserID,DataSourceID) 
go


CREATE TABLE FilterDetail (
  FilterID varchar(38) NULL,
  FilterNumber int NULL,
  Conjunction varchar(3) NULL,
  ColumnName varchar(50) NULL,
  Operator varchar(50) NULL,
  Parameters text NULL
)
go

CREATE INDEX IX1_FilterDetail ON FilterDetail (FilterID,FilterNumber)
go


CREATE TABLE FilterOperators (
  Operator varchar(30) NULL,
  ParametersType varchar(10) NULL,
  SQL varchar(50) NULL,
  ListOrder int NULL,
  OperatorName varchar(4) NULL
)
go

CREATE INDEX IX1_FilterOperators ON FilterOperators (Operator)
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Less Than','Single','< [1]',0,'lt') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Less Than or Equal To','Single','<= [1]',1,'lte') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Greater Than','Single','> [1]',2,'gt') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Greater Than or Equal To','Single','>= [1]',3,'gte') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Equals','Single','= [1]',4,'eq') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not Equal','Single','<> [1]',5,'neq') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Begins With','Single','LIKE ''[1]%''',6,'bw') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not Begin With','Single','NOT LIKE ''[1]%''',7,'nbw') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Contains','Single','LIKE ''%[1]%''',8,'co') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not Contain','Single','NOT LIKE ''%[1]%''',9,'nco') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Ends With','Single','LIKE ''%[1]''',10,'ew') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not End With','Single','NOT LIKE ''%[1]''',11,'new') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Between','Double','BETWEEN [1] AND [2]',12,'btw') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Not Between','Double','NOT BETWEEN [1] AND [2]',13,'nbtw') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is One Of','List','IN ([List])',14,'oo') 
go

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Not One Of','List','NOT IN ([List])',15,'noo') 
go


CREATE TABLE Report (
  ReportID varchar(38) NULL,
  UserID varchar(50) NULL,
  DataSourceID varchar(38) NULL,
  ReportName varchar(100) NULL,
  ReportTitle varchar(100) NULL,
  ReportSubTitle varchar(100) NULL,
  DetailSummaryFlag char(1) NULL,
  LastSavedDate datetime NULL,
  SELECTClause text NULL,
  GROUPBYClause text NULL,
  ORDERBYClause text NULL,
  DrillDownToID varchar(38) NULL
) 
go

CREATE INDEX IX1_Report ON Report (ReportID) 
go
CREATE INDEX IX2_Report ON Report (UserID,DataSourceID) 
go
CREATE INDEX IX3_Report ON Report (DrillDownToID) 
go


CREATE TABLE ReportDetail (
  ReportID varchar(38) NULL,
  ColumnNumber int NULL,
  ColumnName varchar(50) NULL,
  OrderBy char(1) NULL,
  GroupBy char(1) NULL,
  Total char(1) NULL
) 
go

CREATE INDEX IX1_ReportDetail ON ReportDetail (ReportID,ColumnNumber) 
go


CREATE TABLE UserDataSource (
  UserID varchar(50) NULL,
  DataSourceID varchar(38) NULL
)
go

CREATE INDEX IX1_UserDataSource ON UserDataSource (DataSourceID,UserID) 
go


CREATE TABLE Users (
  UserID varchar(50) NULL,
  Name varchar(50) NULL,
  LastLogonDate datetime NULL,
  Active char(1) NULL,
  AccessAllDataSources char(1) NULL,
  SecurityLevel char(1) NULL,
  PasswordChangeDate datetime NULL,
  Password varchar(255) NULL
) 
go

CREATE INDEX IX1_Users ON Users (UserID)
go

INSERT INTO Users (UserID,Name,Active,AccessAllDataSources,SecurityLevel,Password)
VALUES ('admin','Administrator','Y','Y','A','') 
go

